' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System
Imports System.Data
Imports System.Configuration
Imports System.Data.SqlClient

Public Class ListManagerDB

#Region "Konstruktor(y)"

  Private Sub New()
        ' Ukryj konstruktor, poniewa ta klasa ma wycznie skadniki o dostpie wspdzielonym.
  End Sub

#End Region

  ''' <summary>
  ''' Zwraca list rekordw Feature z bazy danych.
  ''' </summary>
  ''' <param name="applicationId">Identyfikator aplikacji w bazie danych, dla ktrej ma by pobrana lista funkcjonalnoci.</param>
  ''' <returns>DataSet zawierajcy dwie kolumny: identyfikator oraz opis funkcji aplikacji</returns>
  Public Shared Function GetFeatureItems(ByVal applicationId As Integer) As DataSet
    Dim dataSet As DataSet = New DataSet
    Dim sql As String = "sprocFeatureSelectList"

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure
        myCommand.Parameters.AddWithValue("@applicationId", applicationId)

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(dataSet)
        myConnection.Close()
        Return dataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function


  ''' <summary>
  ''' Zwraca list rekordw Application z bazy danych.
  ''' </summary>
  ''' <param name="activeOnly">Okrela, czy maj by pobrane tylko aktywne aplikacje.</param>
  ''' <param name="memberId">Identyfikator uytkownika dajcego listy aplikacji.</param>
  ''' <returns>DataSet zawierajcy dwie kolumny: identyfikator oraz opis aplikacji</returns>
  ''' <remarks></remarks>
  Public Shared Function GetApplicationItems( _
      ByVal activeOnly As Boolean, ByVal memberId As Guid) As DataSet

    Dim dataSet As DataSet = New DataSet()
    Dim sql As String = "sprocApplicationSelectList"

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@activeOnly", activeOnly)
        If Not memberId = Guid.Empty Then
          myCommand.Parameters.AddWithValue("@memberId", memberId)
        End If

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(dataSet)

        myConnection.Close()

        Return dataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zwraca list rekordw listy danego typu z bazy danych.
  ''' </summary>
  ''' <param name="theListType">The type of list that must be retrived. See <see cref="ListType">ListType</see> for more details.</param>
  ''' <returns>DataSet zawierajcy dwie kolumny: identyfikator oraz opis typu listy</returns>
  Public Shared Function GetListItems(ByVal theListType As ListType) As DataSet
    Dim dataSet As DataSet = New DataSet
    Dim sql As String = ""
    Select Case theListType
      Case ListType.Frequency
        sql = "sprocFrequencySelectList"
      Case ListType.Reproducibility
        sql = "sprocReproducibilitySelectList"
      Case ListType.Severity
        sql = "sprocSeveritySelectList"
      Case ListType.Status
        sql = "sprocStatusSelectList"
      Case Else
        Throw New ArgumentException("theListType musi by poprawnym " & _
          "wyliczeniem ListType. Bieca warto wynosi " + theListType.ToString)
    End Select

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(dataSet)
        myConnection.Close()

        Return dataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zwraca nazwe aplikacji w oparciu o identyfikator w bazie danych.
  ''' </summary>
  ''' <param name="applicationId">The Id of the application</param>
  Public Shared Function GetApplicationDescription(ByVal applicationId As Integer) As String
    Dim sql As String = ""
    sql = "sprocApplicationSelectDescriptionById"

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure
        myCommand.Parameters.AddWithValue("@applicationId", applicationId)
        Try
          myConnection.Open()
          Return myCommand.ExecuteScalar().ToString()
        Catch ex As Exception
          Throw
        Finally
          myConnection.Close()
        End Try
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

End Class